
#include "stdafx.h"

SensorDescrption *sdAry;
long sensorCnt;

int SelectSensor(SensorDescrption* sd)
{
	long rslt = 0;
	char strBuff[255] = {0};
	char nullChar = '\0';
	char key;
	long x, y;

	// determine the number of sensors currently connected to this system
	sensorCnt = LB_SensorCnt();
	if (sensorCnt<=0) return 0;
	
	// allocate memory for the sensor descriptions
	sdAry = (SensorDescrption*)malloc(sensorCnt*sizeof(SensorDescrption));
	if (sdAry==NULL) return 0;

	// clear serial number strings 
	for (long i = 0; i < sensorCnt; i++)
		memset(&sdAry[i].SerialNumber,'\0', 8);

	// get the index, address and serial number of each sensor
	rslt = LB_SensorList(sdAry, sensorCnt);

	// paint the screen
	ClearScreen();
	memset(strBuff, '\0', 255);
	sprintf(strBuff, "Select a sensor (1..%d):", sensorCnt);
	x = 5;
	y = 5;
	WriteChrsAt(strBuff, x, y);
	y++; y++;
	memset(strBuff, '\0', 255);
	sprintf(strBuff, "%*s%*s%*s", 5, "Idx", 5, "Addr", 8, "SN  ");
	WriteChrsAt(strBuff, x, y++);
	WriteChrsAt("====================", x, y++);
	for (long i = 0; i < sensorCnt; i++)
	{
		sprintf(strBuff, "%*d%*d%*s", 5, sdAry[i].DeviceIndex, 5, sdAry[i].DeviceAddress, 8, sdAry[i].SerialNumber);
		WriteChrsAt(strBuff, x, y++);
	}
	y++;

	// get the selection
	key = '\0';
	long freq = 400;
	long beepLen = 1;
	while (((key<'0')||(key>(sensorCnt+'0')))&&(key!='q')&&(key!='Q'))
	{
		Beep(freq, beepLen);
		beepLen = 100;
		WriteChrsAt("enter sensor index, press return (Quit = q or Q)...", x, y);
		key = getchar();
	}

	// return 0 if quiting
	if ((key=='q')||(key=='Q')) return 0;

	// convert key to index
	long aryIdx = atoi(&key);

	// copy the selected sensor description to the return description
	memcpy(sd, &sdAry[aryIdx-1], sizeof(SensorDescrption));
	y++; y++;	
	WriteChrsAt("initializing sensor, pleas wait (5 seconds)...", x, y);

	// free memory
	free(sdAry);

	return 1;
}