#include "stdafx.h"

int _tmain(int argc, _TCHAR* argv[])
{
	long rslt = 0;
	SensorDescrption sd;

	ShowIntroductoryScreen();
	if (SelectSensor(&sd)==0) return 0;

	// ===========================================
	// Before we enter the command loop and make
	// measurements we must initialize the sensor.
	// Each sensor has calibration coefficients
	// stored inside the sensor. These data must
	// be read and calibration tables created.
	// These calibration tables are then held in 
	// by driver (LB_API2). All this is done with
	// a single command. Initialization takes about
	// 5 seconds. If initialization succeeds a 
	// value > 0 is returned. We can initialize
	// using index, address or serial number. We'll
	// use address. 
	// -------------------------------------------
	if (LB_InitializeSensor_Addr(sd.DeviceAddress)<=0)
	{
		QuitUnableToInitialize();
		Pause();
		return 0;
	}
	rslt = EnterCommandLoop(sd);
	return 0;
}
