#include "stdafx.h"

const long FIRST_LINE = 1;
const long MAX_AVG = 10000;
const long MIN_AVG = 1;
const long MAX_ADDRESS = 255;
const long MIN_ADDRESS = 1;
const double MAX_OFFSET = 200.0;
const double MIN_OFFSET = -200.0;
const double MAX_DC = 100.0;	// per cent
const double MIN_DC = 0.0001;	// per cent
double MAX_FREQ = 10.0;			// GHz
double MIN_FREQ = 0.01;			// GHz
char* unitStr[] = {"DBM", "DBW", "DBKW", "DBUV", "DBMV", "DBV", "W", "V", "DBREL"};

//=========================================
// Change the address of the sensor
//-----------------------------------------
int ChangeAddress(long address)
{
	long newAddr = 0;
	long rslt = 0;
	char buffOut[255] = {0};
	char buffIn[255] = {0};

	sprintf(buffOut, "Current Address = %d", address);
	ClearScreen();
	WriteChrsAt(buffOut, 5, 2);
	WriteChrsAt("enter new address: ", 5, 4);
	scanf("%s", buffIn);
	newAddr = atoi(buffIn);
	if (newAddr<=MIN_ADDRESS) newAddr = MIN_ADDRESS;
	if (newAddr>=MAX_ADDRESS) newAddr = MAX_ADDRESS;
	rslt = LB_ChangeAddress(address, newAddr);
	if (rslt > 0)
		return newAddr;
	else
		return address;
}

//=========================================
// Blink the LED of the sensor
//-----------------------------------------
void BlinkLED(long address)
{
	long rslt = LB_BlinkLED_Addr(address);
}

//=========================================
// Set the frequency of the sensor
//-----------------------------------------
void GetSetFreqeuncy(long address)
{
	MODEL_NUMBER mn = LB4xxA;
	double currFreq = 0.0;
	float newFreq = 0.0;
	long rslt = 0;
	char buffOut[255] = {0};
	char buffIn[255] = {0};

	rslt = LB_GetFrequency(address, &currFreq);	
	sprintf(buffOut, "Current Frequency = %9.3f GHz", currFreq/1e9);
	ClearScreen();
	WriteChrsAt(buffOut, 5, 2);
	WriteChrsAt("enter new freq (GHz): ", 5, 4);
	scanf("%s", buffIn);
	newFreq = atof(buffIn);
	// constrain the frequency to valid range
	rslt = LB_GetModelNumber_Addr(address, &mn);
	switch (mn)
	{
	case LB478A:
	case LB479A:
	case LB480A:
		break;
	case LB559A:
		MAX_FREQ = 12.5;
		break;
	case LB579A:
		MAX_FREQ = 18.0;
		break;
	case LB589A:
		MAX_FREQ = 26.5;
		break;
	}
	if (newFreq<=MIN_FREQ) newFreq = MIN_FREQ;
	if (newFreq>=MAX_FREQ) newFreq = MAX_FREQ;

	// set the frequency
	rslt = LB_SetFrequency(address, newFreq * 1e9);
}

//=========================================
// Set the averaging of the sensor
//-----------------------------------------
void GetSetAveraging(long address)
{
	long currAvgs = 0;
	long newAvgs = 0;
	long rslt = 0;
	char buffOut[255] = {0};
	char buffIn[255] = {0};

	rslt = LB_GetAverages(address, &currAvgs);	
	sprintf(buffOut, "Current Averages = %d", currAvgs);
	
	ClearScreen();
	WriteChrsAt(buffOut, 5, 2);
	WriteChrsAt("enter new averages: ", 5, 4);
	scanf("%s", buffIn);
	newAvgs = atoi(buffIn);
	if (newAvgs<=MIN_AVG) newAvgs = MIN_AVG;
	if (newAvgs>=MAX_AVG) newAvgs = MAX_AVG;
	rslt = LB_SetAverages(address, newAvgs);
}

//=========================================
// Set the offset (in dB) of the sensor
//-----------------------------------------
void GetSetOffset(long address)
{
	double currOffsetDB = 0.00;
	double newOffsetDB = 0.0;
	long rslt = 0;
	char buffOut[255] = {0};
	char buffIn[255] = {0};

	rslt = LB_GetOffset(address, &currOffsetDB);	
	sprintf(buffOut, "Current Offset = %8.3f", currOffsetDB);
	
	ClearScreen();
	WriteChrsAt(buffOut, 5, 2);
	WriteChrsAt("enter new offset (dB): ", 5, 4);
	scanf("%s", buffIn);
	newOffsetDB = atof(buffIn);
	if (newOffsetDB<=MIN_OFFSET) newOffsetDB = MIN_OFFSET;
	if (newOffsetDB>=MAX_OFFSET) newOffsetDB = MAX_OFFSET;
	rslt = LB_SetOffset(address, newOffsetDB);
}

//=========================================
// Enable or disable the offset feature
//-----------------------------------------
void EnableDisableOffset(long address)
{
	FEATURE_STATE currState = OFF;
	FEATURE_STATE newState = OFF;
	char buffOut[255] = {0};
	char buffIn[255] = {0};
	long rslt; 

	rslt = LB_GetOffsetEnabled(address, &currState);	
	ClearScreen();
	if (currState==ON)
		WriteChrsAt("Offset State = Enabled", 5, 2);
	else
		WriteChrsAt("Offset State = Disabled", 5, 2);
	WriteChrsAt("New state: Enable=1 Disable=0, Q=Quit: ", 5, 4);
	buffIn[0] = ReturnSelectionI("01Q\n", 10);
	newState = (FEATURE_STATE)atoi(buffIn);
	if (newState>=ON) newState = ON;
	if (newState<=OFF) newState = OFF;
	rslt = LB_SetOffsetEnabled(address, newState);
}

//=========================================
// Enable or disable anti-aliasing
//-----------------------------------------
void EnableDisableAntialising(long address)
{
	FEATURE_STATE currState = OFF;
	FEATURE_STATE newState = OFF;
	char buffOut[255] = {0};
	char buffIn[255] = {0};
	long rslt; 

	rslt = LB_GetAntiAliasingEnabled(address, &currState);	
	ClearScreen();
	if (currState==ON)
		WriteChrsAt("Anti-aliasing State = Enabled", 5, 2);
	else
		WriteChrsAt("Anti-aliasing State = Disabled", 5, 2);
	WriteChrsAt("New state: Enable=1 Disable=0, Q=Quit: ", 5, 4);
	buffIn[0] = ReturnSelectionI("01Q\n", 10);
	newState = (FEATURE_STATE)atoi(buffIn);
	if (newState>=ON) newState = ON;
	if (newState<=OFF) newState = OFF;
	rslt = LB_SetAntiAliasingEnabled(address, newState);
}

//=========================================
// Set the duty cyle offset for the sensor
//
// This setting is not needed for the 
// LB478A, LB479A and LB480A since they
// measure duty cycle directly. However,
// it will work for these sensors.
//
// This setting is the traditional means
// of measuring peak power. The duty cycle
// setting is simple used as a offset to
// the average power measurement. 
//-----------------------------------------
void GetSetDutyCycle(long address)
{
	double currDC = 0.00;
	double newDC = 0.0;
	long rslt = 0;
	char buffOut[255] = {0};
	char buffIn[255] = {0};

	rslt = LB_GetDutyCyclePerCent(address, &currDC);	
	
	ClearScreen();
	sprintf(buffOut, "Current Duty Cycle = %8.3f", currDC);
	WriteChrsAt(buffOut, 5, 2);
	WriteChrsAt("enter new DC offset (%): ", 5, 4);
	scanf("%s", buffIn);
	newDC = atof(buffIn);
	if (newDC<=MIN_DC) newDC= MIN_DC;
	if (newDC>=MAX_DC) newDC= MAX_DC;
	rslt = LB_SetDutyCyclePerCent(address, newDC);
}

//=========================================
// Enable or disable duty cyle offset for 
// the sensor
//
// This setting is not needed for the 
// LB478A, LB479A and LB480A since they
// measure duty cycle directly. However,
// it will work for these sensors.
//
// This setting is the traditional means
// of measuring peak power. The duty cycle
// setting is simple used as a offset to
// the average power measurement. 
//-----------------------------------------
void EnableDisableDutyCycle(long address)
{
	FEATURE_STATE currState = OFF;
	FEATURE_STATE newState = OFF;
	char buffOut[255] = {0};
	char buffIn[255] = {0};
	long rslt; 

	rslt = LB_GetDutyCycleEnabled(address, &currState);	
	ClearScreen();
	if (currState==ON)
		WriteChrsAt("Duty Cycle State = Enabled", 5, 2);
	else
		WriteChrsAt("Duty Cycle State = Disabled", 5, 2);
	WriteChrsAt("New state: Enable=1 Disable=0, Q=Quit: ", 5, 4);
	buffIn[0] = ReturnSelectionI("01Q\n", 10);
	newState = (FEATURE_STATE)atoi(buffIn);
	if (newState>=ON) newState = ON;
	if (newState<=OFF) newState = OFF;
	rslt = LB_SetDutyCycleEnabled(address, newState);
}

//=========================================
// Set the measurement power units
//-----------------------------------------
void GetSetPowerUnits(long address)
{
	PWR_UNITS currUnits = DBM;
	PWR_UNITS newUnits = DBM;
	long rslt = 0;
	char buffOut[255] = {0};
	char buffIn[255] = {0};
	rslt = LB_GetMeasurementPowerUnits(address, &currUnits);	
	sprintf(buffOut, "Current Units: %s", unitStr[currUnits]);
	ClearScreen();
	WriteChrsAt(buffOut, 5, 2);
	WriteChrsAt("Available Units: ", 5, 4);
	WriteChrsAt("0 DBM", 5, 6);
	WriteChrsAt("1 DBW", 5, 7);
	WriteChrsAt("2 DBKW", 5, 8);
	WriteChrsAt("3 DBUV", 5, 9);
	WriteChrsAt("4 DBMV", 5, 10);
	WriteChrsAt("5 DBV", 5, 11);
	WriteChrsAt("6 W", 5, 12);
	WriteChrsAt("7 V", 5, 13);
	WriteChrsAt("8 DBREL", 5, 14);
	WriteChrsAt("Q = Quit", 5, 15);
	WriteChrsAt("Enter 0..8 (9 to quit): ", 5, 17);
	buffIn[0] = ReturnSelectionI("012345678Q\n", 10);

	if (toupper(buffIn[0])=='Q'||toupper(buffIn[0])=='9') return;

	newUnits = (PWR_UNITS)atoi(buffIn);
	if (newUnits>=DBM&&newUnits<=DBREL)
		rslt = LB_SetMeasurementPowerUnits(address, newUnits);
}

//=========================================
// Measure the CW or average power
//-----------------------------------------
void MeasureCWPower(long address)
{
	double CW = 0.00;
	long rslt = 0;
	char buffOut[255] = {0};
	char buffIn[255] = {0};
	bool again = TRUE;
	
	while (again)
	{
		rslt = LB_MeasureCW(address, &CW);	
		ClearScreen();
		sprintf(buffOut, "Avgerage Power = %8.3f", CW);
		WriteChrsAt(buffOut, 5, 2);
		WriteChrsAt("Repeat = Return: Quit = Q: ", 5, 4);
		buffIn[0] = ReturnSelectionI("RQ\n", 10);
		again = buffIn[0]!='Q' && buffIn[0]!='q';
	}
}

//=========================================
// Measure the pulse power includes
//	- average power in the pulse (pls)
//	- peak power in the pusle
//	- average power
//	- duty cycle
// 
//	calculate creast facotr (peak-avg)
//-----------------------------------------
void MeasurePulsePower(long address)
{
	double pls = 0.00;
	double pk = 0.00;
	double avg = 0.00;
	double dc = 0.00;
	double crf = 0.00;
	long rslt = 0;
	char buffOut[255] = {0};
	char buffIn[255] = {0};
	bool again = TRUE;
	
	PWR_UNITS currUnits = DBM;
	rslt = LB_GetMeasurementPowerUnits(address, &currUnits);		// used in the calculation of crest factor
	while (again)
	{
		rslt = LB_MeasurePulse(address, &pls, &pk, &avg, &dc);
		switch (currUnits)
		{
		case DBM:
		case DBW:
		case DBKW:
		case DBUV:
		case DBMV:
		case DBV:
		case DBREL:
			ClearScreen();
			crf = pk - avg;
			sprintf(buffOut, "Pulse Power = %8.3f %s", pls, unitStr[currUnits]);
			WriteChrsAt(buffOut, 5, 2);
			sprintf(buffOut, "Peak Power = %8.3f", pk, unitStr[currUnits]);
			WriteChrsAt(buffOut, 5, 3);
			sprintf(buffOut, "Average Power = %8.3f", avg, unitStr[currUnits]);
			WriteChrsAt(buffOut, 5, 4);
			sprintf(buffOut, "Duty Cycle = %8.3f %%%%", dc * 100.0);
			WriteChrsAt(buffOut, 5, 5);
			sprintf(buffOut, "Crest Factor = %8.3f dB", crf);
			WriteChrsAt(buffOut, 5, 6);
			break;
		case W:
			ClearScreen();
			crf = 10.0 * log10(pk/avg);
			sprintf(buffOut, "Pulse Power = %8.3e", pls, unitStr[currUnits]);
			WriteChrsAt(buffOut, 5, 2);
			sprintf(buffOut, "Peak Power = %8.3e", pk, unitStr[currUnits]);
			WriteChrsAt(buffOut, 5, 3);
			sprintf(buffOut, "Average Power = %8.3e", avg, unitStr[currUnits]);
			WriteChrsAt(buffOut, 5, 4);
			sprintf(buffOut, "Duty Cycle = %8.3f %%%%", dc * 100.0);
			WriteChrsAt(buffOut, 5, 5);
			sprintf(buffOut, "Crest Factor = %8.3f dB", crf);
			WriteChrsAt(buffOut, 5, 6);
			break;
		case V:
			ClearScreen();
			crf = 20.0 * log10(pk/avg);
			sprintf(buffOut, "Pulse Power = %8.3e", pls, unitStr[currUnits]);
			WriteChrsAt(buffOut, 5, 2);
			sprintf(buffOut, "Peak Power = %8.3e", pk, unitStr[currUnits]);
			WriteChrsAt(buffOut, 5, 3);
			sprintf(buffOut, "Average Power = %8.3e", avg, unitStr[currUnits]);
			WriteChrsAt(buffOut, 5, 4);
			sprintf(buffOut, "Duty Cycle = %8.3f %%%%", dc * 100.0);
			WriteChrsAt(buffOut, 5, 5);

			sprintf(buffOut, "Crest Factor = %8.3f dB", crf);
			WriteChrsAt(buffOut, 5, 6);
			break;
		}
		WriteChrsAt("Repeat = R: Quit = Q: ", 5, 8);
		buffIn[0] = ReturnSelectionI("RQ\n", 10);
		again = buffIn[0]=='R'|| buffIn[0]=='r';
	}
}


//=========================================
// COMMAND LOOP
//-----------------------------------------
int EnterCommandLoop(SensorDescrption sd)
{
	long rslt = 0;
	long y = FIRST_LINE;
	char k = '\0';

	while ((k!='q')&&(k!='Q'))
	{
		ClearScreen();
		WriteChrsAt("Enter Command:", 5, 2);
		WriteChrsAt("---------------", 5, 3);
		WriteChrsAt("B = Blink LED", 5, 4);
		WriteChrsAt("F = Get\Set Frequency", 5, 5);
		WriteChrsAt("A = Get\Set Averaging", 5, 6);
		WriteChrsAt("N = Get\Set Anti Aliasing", 5, 7);
		WriteChrsAt("U = Get\Set Measurment Units", 5, 8);
		WriteChrsAt("D = Get\Set Address", 5, 9);
		WriteChrsAt("Y = Set Duty Setting", 5, 10);
		WriteChrsAt("W = Enable\Disable Duty Cycle", 5, 11);
		WriteChrsAt("T = Get\Set Offset", 5, 12);
		WriteChrsAt("O = Enable\Disable Offset", 5, 13);
		WriteChrsAt("C = Measure CW or Average Power", 5, 14);
		WriteChrsAt("P = Measure Pulse/Peak Power", 5, 15);
		WriteChrsAt("Q = Quit", 5, 16);
		WriteChrsAt("enter command...", 5, 18);
		k = ReturnSelectionI("BFANUDYWTOCPQ\n", 10);
		switch (k)
		{
		case 'a':													// AVERAGING
		case 'A':
			GetSetAveraging(sd.DeviceAddress);
			break;
		case 'b':													// BLINK LED
		case 'B':
			BlinkLED(sd.DeviceAddress);
			break;
		case 'c':													// MEASURE CW POWER
		case 'C':
			MeasureCWPower(sd.DeviceAddress);
			break;
		case 'd':													// ADDRESS
		case 'D':
			sd.DeviceAddress = ChangeAddress(sd.DeviceAddress);
			break;
		case 'f':													// FREQUENCY
		case 'F':
			GetSetFreqeuncy(sd.DeviceAddress);
			break;
		case 'o':													// ENABLE OFFSET
		case 'O':
			EnableDisableOffset(sd.DeviceAddress);
			break;
		case 'n':													// ENABLE ANTI-ALIASING
		case 'N':
			EnableDisableOffset(sd.DeviceAddress);
			break;
		case 'p':													// MEASURE PULSE POWER
		case 'P':
			MeasurePulsePower(sd.DeviceAddress);
			break;
		case 't':													// SET OFFSET
		case 'T':
			GetSetOffset(sd.DeviceAddress);
			break;
		case 'u':													// UNITS
		case 'U':
			GetSetPowerUnits(sd.DeviceAddress);
			break;
		case 'w':													// ENABLE DUTY CYCLE
		case 'W':
			EnableDisableDutyCycle(sd.DeviceAddress);
			break;
		case 'y':													// SET DUTY CYCLE
		case 'Y':
			GetSetDutyCycle(sd.DeviceAddress);
			break;
		case 'q':													// QUIT
		case 'Q':
			return 0;
		}
	}
}