#include "stdafx.h"
long const MIN_SELS = 1;
long const MAX_SELS = 100;

//=================================================================
// Return a single upper cased character - echo to screen
//-----------------------------------------------------------------
char GetEchoSingleCharUCase()
{
	char ch = toupper(_getch());
	_putch_nolock(ch);
	return ch;
}

//=================================================================
// Return a single character - echo to screen
//-----------------------------------------------------------------
char GetSingleChar()
{
   int ch;
   ch = _getch();
   return ch;
}

//=================================================================
// Return a single character - do not echo to screen
//-----------------------------------------------------------------
char GetEchoSingleChar()
{
   int ch;

  ch = GetSingleChar();
  _putch_nolock(ch);
  return ch;
}

//=================================================================
// Wait for a key press of any kind
//-----------------------------------------------------------------
void Pause(void)
{
	char ch;
	ch = _getch();
}

//=================================================================
// Clear the screen...lazy but it works
//-----------------------------------------------------------------
void ClearScreen(void)
{
	system("cls\n");
}

//=================================================================
// Return a single upper cased character - do not echo to screen
//-----------------------------------------------------------------
char GetSingleCharUCase()
{
	return toupper(GetSingleChar());
}

//=================================================================
// Return the first character in the set
//-----------------------------------------------------------------
char ReturnSelectedCharUCase()
{
	return toupper(GetSingleChar());
}

//=================================================================
// Return the first character in the set (upper case all)
//-----------------------------------------------------------------
char ReturnSelectionI(char* charToSel, int maxAttempts)
{
	char copySels[256] = {0};
	long selCnt = strlen(charToSel);			// how many selections?
	long attemptsSoFar = 0;						// haven't tried yet
	char ch[2] = {0};							// 2 char string
	char* strFound = NULL;						// haven't found anything yet
	long strLength = strlen(charToSel);

	if (strLength<1||strLength>255) return '\0';
	strncpy(copySels, charToSel, strLength);
	if (selCnt < MIN_SELS || selCnt > MAX_SELS) return '\0';
	// upper case the selections
	for (long i = 0; i < strLength; i++)
		copySels[i] = toupper(charToSel[i]);
	do
	{
		ch[0] = toupper(GetSingleChar());
		strFound = strstr(copySels, ch);
		if (strFound!=NULL) return ch[0];
		attemptsSoFar++;
	} while (attemptsSoFar<maxAttempts);
	return '\0';
}

//=================================================================
// Return the first character in the set
//-----------------------------------------------------------------
char ReturnSelection(char* charToSel, int maxAttempts)
{
	long selCnt = strlen(charToSel);			// how many selections?
	long attemptsSoFar = 0;						// haven't tried yet
	char ch[2] = {0};							// 2 char string
	char* strFound = NULL;						// haven't found anything yet
	
	if (selCnt < MIN_SELS || selCnt > MAX_SELS) return '\0';
	do
	{
		ch[0] = GetSingleChar();
		strFound = strstr(charToSel, ch);
		if (strFound!=NULL) return ch[0];
		attemptsSoFar++;
	} while (attemptsSoFar<maxAttempts);
	return '\0';
}

//=================================================================
// Return the first character in the set
//-----------------------------------------------------------------
char ReturnSelectionUCase(char* charToSel, int maxAttempts)
{
	long selCnt = strlen(charToSel);			// how many selections?
	long attemptsSoFar = 0;						// haven't tried yet
	char ch[2] = {0};							// 2 char string
	char* strFound = NULL;						// haven't found anything yet
	
	if (selCnt < MIN_SELS || selCnt > MAX_SELS) return '\0';
	for (long i = 0; i<selCnt; i++) charToSel[i] = toupper(charToSel[i]);
	do
	{
		ch[0] = GetSingleCharUCase();
		strFound = strstr(charToSel, ch);
		if (strFound!=NULL) return ch[0];
		attemptsSoFar++;
	} while (attemptsSoFar<maxAttempts);
	return '\0';
}

//=================================================================
// Write chr to the screen starting at location {x,y}
//-----------------------------------------------------------------
int WriteChrsAt(char* chr, long x, long y)
{
	HANDLE hConsole = GetStdHandle(STD_OUTPUT_HANDLE);
	COORD pos = {x, y};

	if (INVALID_HANDLE_VALUE != hConsole)
	{
		SetConsoleCursorPosition(hConsole, pos);
		printf(chr);
		return 1;
	}
	else return 0;
}
